// GpPenEscB.cpp : implementation file
//

#include "stdafx.h"
#include "defsfile.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscB Dialog


CGpPenEscB::CGpPenEscB(CWnd* pParent /*=NULL*/)
	:CIndecateRect(CGpPenEscB::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpPenEscB)
	m_cLineStyle = 0;
	//}}AFX_DATA_INIT

	m_bAction = FALSE ;

	Create(IDD,pParent);
}


void CGpPenEscB::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpPenEscB)
	DDX_CBIndex(pDX, IDC_cLineStyle, m_cLineStyle);
	//}}AFX_DATA_MAP

}


BEGIN_MESSAGE_MAP(CGpPenEscB, CDialog)
	//{{AFX_MSG_MAP(CGpPenEscB)
		// 
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscB Message Handler

void CGpPenEscB::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	delete this ;
}



// Create Content
CContents*  CGpPenEscB::CreateContents()
{
	// Create empty content
	CContentsEscB* pContents = new CContentsEscB();

	// Set the data from dialog
	UpdateData(TRUE);
	pContents->m_Data.cDisplayColor = theApp.m_cDisplayColor  ;
	pContents->m_Data.cBackColor = theApp.m_cBackColor  ;

	// Line Style
	pContents->m_Data.cLineStyle = m_cLineStyle ;
	if( pContents->m_Data.cLineStyle > 3 )
	{
		pContents->m_Data.cLineStyle += 4 ;
	}

	// Set Content the display position
	pContents->m_Data.iX1 = m_iX1 ;
	pContents->m_Data.iY1 = m_iY1 ;
	pContents->m_Data.iX2 = m_iX2 ;
	pContents->m_Data.iY2 = m_iY2 ;
	return( pContents );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Draw Box
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Erase drawing
void CIndecateRect::ActionErase(CDC* pDC)
{
	if( m_bAction ){
		InvertBox(pDC,m_iX1,m_iY1,m_iX2,m_iY2);
		m_bAction = FALSE ;
	}
}

// Draw to the new position
void CIndecateRect::ActionDisplay(CPoint NewPoint,CDC* pDC)
{
	// Erase
	ActionErase(pDC);

	// Draw at new position
	m_iX2 = NewPoint.x ;
	m_iY2 = NewPoint.y ;
	InvertBox(pDC,m_iX1,m_iY1,m_iX2,m_iY2);
	m_bAction = TRUE ;
}


// Start Drawing
int  CIndecateRect::ActionDown(UINT nFlags, CPoint point,CDC* pDC)
{
	m_iX1 = point.x ;
	m_iY1 = point.y ;

	// Draw
	ActionDisplay(point,pDC) ;

	return( B_ActionContinue );	// Continue
}


// Move
int  CIndecateRect::ActionMove(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionDisplay(point,pDC) ;

	return( B_ActionContinue );	// Continue
}

// End
int  CIndecateRect::ActionUp(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionDisplay(point,pDC) ;

	ActionErase(pDC) ;

	return( B_ActionOk );
}

// Cancel
int  CIndecateRect::ActionCancel(CDC* pDC)
{
	ActionErase(pDC) ;

	return( B_ActionStop );
}
